// Copyright Thomas Dreibholz, uzs6pq@ibm.rhrz.uni-bonn.de
// Lsung des Frbe-Problems mittels Backtracking:
// Gegeben: Lnder und Grenzen
// Gesucht: Frbung der Lnder mit gegebener Farbenzahl
// Aufruf:  faerb
//          Skript-Datei      = Dateiname
//         +f                = falsche Anstze zeigen

#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <fstream.h>
#include <string.h>


const int cMaxLaender = 500;
class Land;


// ===== Klasse "Weg" ====================================================

// Klasse "Weg"
class Weg
{
   public:
   Weg();                            // Konstruktor
   ~Weg();                           // Destruktor
   void Push(int nummer, int farbe); // Lndernummer ablegen
   void Pop();                       // Lndernummer wegnehmen
   int  Laender();                   // Anzahl der Lnder auf dem Weg

   friend ostream& operator << (ostream& os, Weg* weg)   // Ausgabe

   private:
   int Zaehler;
   int Liste[cMaxLaender];
   int Farbe[cMaxLaender];
};

// Konstruktor fr Klasse "Weg"
Weg::Weg()
{
   Zaehler = 0;
}

// Destruktor fr Klasse "Weg"
Weg::~Weg()
{
}

// Neue Lndernummer hinzufgen
void Weg::Push(int nummer, int farbe)
{
   if(Zaehler < cMaxLaender - 1) {
      Farbe[Zaehler] = farbe;
      Liste[Zaehler] = nummer;
      Zaehler++;
   }
   else {
      cout << "Fehler bei Weg::Push()";
      exit(1);
   }
}

// Lndernummer entfernen
void Weg::Pop()
{
   Zaehler--;
   if(Zaehler < 0) {
      cout << "Fehler bei Weg::Pop()";
      exit(1);
   }
}

// Anzahl der Lnder auf dem Weg abfragen
inline int Weg::Laender()
{
   return(Zaehler);
}

// Ausgabe eines Weges als n-Tupel
ostream& operator <<(ostream& os, Weg* weg)
{
   int i;

   os << "Weg=(";
   for(i = 0;i < weg->Zaehler;i++) {
      os << weg->Liste[i];
      if(i != weg->Zaehler - 1) {
         os << ",";
      }
   }
   os << "), Farben=(";
   for(i = 0;i < weg->Zaehler;i++) {
      os << weg->Farbe[i];
      if(i != weg->Zaehler - 1) {
         os << ",";
      }
   }
   os << ")";
   return os;
}

// ===== Klasse "Grenze" =============================================

// Klasse "Grenze"
// Diese Klasse dient zur Speicherung der Grenze zwischen zwei Lndern.
class Grenze
{
   public:
   Grenze(Land* ziel);         // Konstruktor
   ~Grenze();                  // Destruktor
   Land*   Zielland();         // Zielland der Grenze

   // Verkettung von Grenzen
   void    Naechste(Grenze* grenze);   // Zeiger setzen
   Grenze* Naechste();                 // Zeiger abfragen

   private:
   Land*        Ziel;                  // Zielland
   Grenze* NaechsteGrenze;             // Naechste Grenze
};

// Konstruktor fr Klasse "Grenze"
Grenze::Grenze(Land* ziel)
{
   NaechsteGrenze = NULL;
   Ziel           = ziel;
}

// Destruktor fr Klasse "Grenze"
Grenze::~Grenze()
{
}

// Zielland ermitteln
inline Land* Grenze::Zielland()
{
   return(Ziel);
}

// Zeiger auf nchste Grenze abfragen
inline Grenze* Grenze::Naechste()
{
   return(NaechsteGrenze);
}

// Zeiger aus nchste Grenze setzen
inline void Grenze::Naechste(Grenze* grenze)
{
   NaechsteGrenze = grenze;
}


// ===== Klasse "Land" ====================================================


const int cKeineFarbe = 0;


// Klasse "Land"
// Diese Klasse dient zur Speicherung eines Landes und dessen Grenzen.
class Land
{
   public:
   Land(int nummer);                   // Konstruktor
   ~Land();                            // Destruktor

   void Farbe(int farbe);              // Farbe setzen
   int  Farbe();                       // Farbe erfragen
   int  Nummer();                      // Nummer erfragen
   void Verbinde(Land* ziel);          // Mit anderem Land verbinden

   // Verkettung von Lndern
   void    Naechstes(Land* naechster); // Nchstes Land setzen
   Land*   Naechstes();                // Nchstes Land erfragen
   Grenze* Grenzenliste();             // Zeiger auf Grenzenliste

   private:
   int     Faerbung;
   int     Landnummer;
   Land*   NaechstesLand;
   Grenze* ErsteGrenze;
};

// Konstruktor fr Klasse "Land"
Land::Land(int nummer)
{
   Landnummer    = nummer;
   Faerbung      = cKeineFarbe;
   NaechstesLand = NULL;
   ErsteGrenze   = NULL;
}

// Desstruktor fr Klasse "Land"
Land::~Land()
{
   Grenze* naechste = ErsteGrenze;
   Grenze* grenze;
   while(naechste != NULL) {
      grenze = naechste;
      naechste = naechste->Naechste();
      delete grenze;
   }
}

// Farbe setzen
inline void Land::Farbe(int farbe)
{
   Faerbung = farbe;
}

// Farbe ermitteln
inline int Land::Farbe()
{
   return(Faerbung);
}

// Landnummer abfragen
inline int Land::Nummer()
{
   return(Landnummer);
}

// Zeiger auf nchsten Land abfragen
inline Land* Land::Naechstes()
{
   return(NaechstesLand);
}

// Nchsten Land setzen
inline void Land::Naechstes(Land* naechstes)
{
   NaechstesLand = naechstes;
}

// Zeiger auf erste Grenze
inline Grenze* Land::Grenzenliste()
{
   return(ErsteGrenze);
}

// Land mit einem anderem verbinden
void Land::Verbinde(Land* ziel)
{
   Grenze* grenze = new Grenze(ziel);
   if(grenze == NULL) {
      cout << "Zu wenig Speicher!" << endl;
      exit(1);
   }
   grenze->Naechste(ErsteGrenze);
   ErsteGrenze = grenze;
}


// ===== Klasse "Laenderliste" ===============================================

// Klasse "Lnderliste"
// Diese Klasse dient zur Speicherung und Verwaltung der Lnder.
class Laenderliste
{
   public:
   Laenderliste();                         // Konstruktor
   ~Laenderliste();                        // Destruktor

   void   NeuesLand(int nummer);           // Neues Land einfgen
   Land  *FindeLand(int nummer);           // Zeiger auf Land ermitteln
   void   VerbindeLaender(int n1, int n2); // Lnder verbinden
   int    Laender();            // Anzahl der Lnder in der Liste ermitteln
   Land  *ErstesLand();                    // Zeiger auf erstes Land

   friend ostream& operator << (ostream& os, Laenderliste* ll);  // Ausgabe

   private:
   Land* Startland;                        // Zeiger auf erstes Land
   int   Zaehler;                          // Zhler
}


// Konstruktor fr Klasse "Laenderliste"
Laenderliste::Laenderliste()
{
   Startland = NULL;
   Zaehler   = 0;
}

// Desstruktor fr Klasse "Laenderliste"
Laenderliste::~Laenderliste()
{
   Land* naechster = Startland;
   Land* land;

   while(naechster != NULL) {
      land = naechster;
      naechster = naechster->Naechstes();
      delete land;
   }
}

// Neuen Land zur Laenderliste hinzufgen
void Laenderliste::NeuesLand(int nummer)
{
   if(FindeLand(nummer) != NULL) {
      cout << "Land " << nummer << " existiert bereits." << endl;
   }

   Land* land = new Land(nummer);
   if(land == NULL) {
      cout << "Fehler bei Laenderliste::NeuesLand()" << endl;
      exit(1);
   }

   // Land an Liste anfgen
   if(Startland == NULL) {
      Startland = land;
   }
   else {
      Land* liste = Startland;
      while(liste->Naechstes() != NULL) {
         liste = liste->Naechstes();
      }
      liste->Naechstes(land);
   }
   Zaehler++;
}

// Land suchen
Land* Laenderliste::FindeLand(int nummer)
{
   Land* land = Startland;
   while(land != NULL) {
      if(land->Nummer() == nummer) {
         return(land);
      }
      land = land->Naechstes();
   }
   return(NULL);
}

// berprfen, ob zwei Lnder bereits verbunden sind
int SindVerbunden(Land* land1, Land* land2)
{
   Grenze* grenze = land1->Grenzenliste();
   while(grenze != NULL) {
      if(grenze->Zielland() == land2) {
         return(1);
      }
      grenze = grenze->Naechste();
   }
   return(0);
}

// Lnder miteinander verbinden
void Laenderliste::VerbindeLaender(int n1, int n2)
{
   if(n1 == n2) {
      cout << "Land " << n1 << " kann nicht mit sich selbst verbunden werden!" << endl;
      return;
   }
   Land* land1 = FindeLand(n1);
   Land* land2 = FindeLand(n2);
   if((land1 == NULL) || (land2 == NULL)) {
      cout << "Kann Lnder " << n1 << " und " << n2 << " nicht verbinden:" << endl;
      cout << "Mindestens ein Land existiert nicht!" << endl;
      exit(1);
   }

   if(!(SindVerbunden(land1,land2))) {
      land1->Verbinde(land2);
      land2->Verbinde(land1);
   }
}

// Anzahl der Lnder in der Liste ermitteln
inline int Laenderliste::Laender()
{
   return(Zaehler);
}

inline Land* Laenderliste::ErstesLand()
{
   return(Startland);
}

// Ausgabe der Lnderliste mit Farben
ostream& operator << (ostream& os, Laenderliste* ll)
{
   os << "Lnder: (";
   Land* land = ll->ErstesLand();
   while(land != NULL) {
      os << land->Nummer();
      land = land->Naechstes();
      if(land != NULL) os << ",";
   }

   os << ") Farben: (";
   land = ll->ErstesLand();
   while(land != NULL) {
      os << land->Farbe();
      land = land->Naechstes();
      if(land != NULL) os << ",";
   }
   os << ")";
   return os;
}


// ===== Hauptteil========================================================


int anzahlFarben           = 4;
int zeigeFalscheAnsaetze   = 0;
Laenderliste* laenderliste = NULL;
Land*         start        = NULL;
Weg*          weg          = NULL;

// Statistik
int anzahlLoesungen = 0;   // Anzahl der Lsungen
int anzahlFalsch    = 0;   // Anzahl der falschen Anstze
int ersteLoesung    = -1;  // Anzahl der Schritte bis zur ersten Lsung


// Laenderliste und Grenzen erstellen
void ErstelleLaenderliste(char* name)
{
   ifstream is(name);
   if(is.bad()) {
      cout << "Fehler beim ffnen der Datei <" << name << ">." << endl;
      exit(1);
   }

   laenderliste = new Laenderliste;
   while(!is.eof()) {
      char befehl[80];
      int  a,b;

      is >> befehl;
      if(!(strcmp(befehl,"land"))) {
         is >> a;
         cout << "Neues Land: " << a << endl;
         laenderliste->NeuesLand(a);
      }
      else if(!(strcmp(befehl,"grenze"))) {
         is >> a;
         is >> b;
         cout << "Verbinde Land " << a << " mit " << b << endl;
         laenderliste->VerbindeLaender(a,b);
      }
      else if(!(strcmp(befehl,"farben"))) {
         is >> a;
         if(a >= 1) {
            anzahlFarben = a;
         }
         else {
            cout << "Die Anzahl der zu verwendenden Farben mu mindestens 1 betragen!" << endl;
         }
      }
      else {
         switch(befehl[0]) {
            case '#':
            case '/':
            case 0x00:
             is.getline(befehl,78);
             break;
            default:
               cout << "Syntaxfehler in Skriptdatei" << endl;
               cout << "Zeile <" << befehl << ">" << endl;
               cout << "Abbruch!" << endl;
               exit(1);
             break;
         }
      }
   }
   start = laenderliste->ErstesLand();
   if(start == NULL) {
      cout << "Keine Lnder vorhanden - Abbruch!" << endl;
      exit(1);
   }
   cout << "Anzahl der zu verwendenden Farben: " << anzahlFarben << endl << endl;
}

// Laenderliste wieder lschen
void EntferneLaenderliste()
{
   delete laenderliste;
}

// Der eigentliche Backtracking-Lsungsalgorithmus fr das Frbeproblem
void Backtracking(Land* land)
{
   Grenze* grenze;

   // Alle Farben durchlaufen
   for(int farbe = 1;farbe <= anzahlFarben;farbe++) {

      // Zuerst mu geprft werden, ob irgend ein angrenzendes Land
      // bereits die Farbe farbe angenommen hat.
      int ok = 1;
      grenze = land->Grenzenliste();
      while(grenze != NULL) {
         Land* ziel = grenze->Zielland();
         if(ziel->Farbe() == farbe) {
            ok = 0;
            break;
         }
         grenze = grenze->Naechste();
      }

      // Land auf den Weg-Stack legen
      weg->Push(land->Nummer(),farbe);

      // Falls es keine Konflikte gibt, kann die Farbe verwendet werden.
      if(ok == 1) {
         land->Farbe(farbe);

         // berprfen, ob eine Lsung gefunden wurde
         grenze = land->Grenzenliste();
         if(laenderliste->Laender() == weg->Laender()) {
            cout << "** Lsung gefunden: " << weg << " **" << endl;
            anzahlLoesungen++;
            if(ersteLoesung == -1) {
               ersteLoesung = anzahlFalsch;
            }
         }
         else {
            // Nchsten Land in nchster Rekursionsstufe bearbeiten
            if(land->Naechstes()) {
               Backtracking(land->Naechstes());
            }
         }

         // Frbung wieder rckgngig machen
         land->Farbe(cKeineFarbe);
      }
      // Falls diese Farbe nicht verwendet werden kann, Fehler zhlen
      else {
         if(zeigeFalscheAnsaetze) {
            cout << "Kein Lsung: " << weg << endl;
         }
         anzahlFalsch++;
      }

      // Letztes Land von Weg-Stack entfernen
      weg->Pop();
   }
}


// Hauptprogramm
void main(int argc, char *argv[])
{
   cout << "Backtracking-Beispielprogramm #2 - Frbeproblem" << endl;

   if(argc >= 2) {
      ErstelleLaenderliste(argv[1]);
      if(argc >= 3) {
         if(!(strcmp(argv[2],"+f"))) {
            zeigeFalscheAnsaetze = 1;
         }
      }
   }
   else {
      cout << "Aufruf: " << argv[0] << " [Skript]" << endl;
      exit(0);
   }

   weg = new Weg;
   if(weg == NULL) {
      cout << "Nicht genug Speicher!" << endl;
      exit(1);
   }

   Backtracking(start);
   EntferneLaenderliste();

   cout << "Keine (weiteren) Lsungen gefunden." << endl << endl;
   cout << "STATISTIK:" << endl;
   if(ersteLoesung != -1) {
      cout << "Erste Lsung nach " << ersteLoesung << " Fehlversuchen" << endl;
   }
   cout << "Anzahl der gefundenen Lsungen: " << anzahlLoesungen << endl;
   cout << "Anzahl der falschen Anstze:    " << anzahlFalsch << endl;
   cout << "GESAMT:                         " << anzahlLoesungen + anzahlFalsch << endl;
   char c = getc(stdin);
   delete weg;
}
